
/*
  I2C Slave Demo (Nano)
  Demo communicatie van 4 nano's via de I2C bus
  De slave ontvangt gegevens va de master en antwoord hierop
*/

#include <Wire.h>

/* Definieer het I2C adres
 * 4x Arduino Nano: 9, 10, 11, 12
 * Kies voor iedere slave nano een  ander adres!
 * De keuze is 9, 10, 11 of 12
 */
#define SLAVE_ADDR 12 

// Define Slave answer size
#define ANSWERSIZE 23

// Define string with response to Master
String adressHex = String(SLAVE_ADDR, HEX);
String answer = "Hoi ik ben NANO HEX $0";

void setup() {
  adressHex.toUpperCase();
  answer += adressHex;

  // Initialize I2C communications as Slave
  Wire.begin(SLAVE_ADDR);

  // Function to run when data requested from master
  Wire.onRequest(requestEvent);

  // Function to run when data received from master
  Wire.onReceive(receiveEvent);

  // Setup Serial Monitor
  Serial.begin(9600);
  Serial.println("I2C slave demo");
}

void receiveEvent() {

  String received = "";

  // Read while data received
  while (0 < Wire.available()) {
    char x = Wire.read();

    received += x;
  }

  // Print to Serial Monitor
  Serial.print("Receive event : ");
  Serial.println(received);
}

void requestEvent() {

  // Setup byte variable in the correct size
  byte response[ANSWERSIZE];

  // Format answer as array
  for (byte i = 0; i < ANSWERSIZE; i++) {
    response[i] = (byte)answer.charAt(i);
  }

  // Send response back to Master
  Wire.write(response, sizeof(response));

  // Print to Serial Monitor
  Serial.println("Request event");
}

void loop() {

  // Time delay in loop
  delay(50);
}
